<?php
// admin_perfil_promoter.php - CORRIGIDO PARA ERRO 500
require_once 'config.php';
verificarRole(['admin']);

$sucesso = '';
$erro = '';

if (!isset($_GET['id'])) {
    header('Location: admin_usuarios.php');
    exit;
}

$promoter_id = intval($_GET['id']);

// Buscar dados do promoter
$stmt = $pdo->prepare("SELECT * FROM users WHERE id = ? AND role IN ('user', 'gerente')");
$stmt->execute([$promoter_id]);
$promoter = $stmt->fetch();

if (!$promoter) {
    header('Location: admin_usuarios.php');
    exit;
}

// Lançar bônus - CORRIGIDO
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['lancar_bonus'])) {
    $valor = floatval($_POST['valor_bonus']);
    $tipo = $_POST['tipo_bonus']; // 'dinheiro' ou 'consumacao'
    
    // CORREÇÃO: sanitizar string corretamente para PHP 8+
    $descricao = isset($_POST['descricao']) ? htmlspecialchars(trim($_POST['descricao']), ENT_QUOTES, 'UTF-8') : '';
    
    if ($valor > 0) {
        try {
            if ($tipo === 'dinheiro') {
                // Criar comissão de bônus (evento_id = 0 para indicar bônus)
                $stmt = $pdo->prepare("
                    INSERT INTO comissoes (user_id, evento_id, valor, convidados_total, convidados_checkin, status, created_at)
                    VALUES (?, 0, ?, 0, 0, 'disponivel', NOW())
                ");
                if ($stmt->execute([$promoter_id, $valor])) {
                    $sucesso = '<i class="fas fa-money-bill-wave"></i> Bônus de R$ ' . number_format($valor, 2, ',', '.') . ' creditado como DINHEIRO!';
                }
            } else {
                // CORREÇÃO: Usar 'processando' ao invés de 'aprovado'
                $stmt = $pdo->prepare("
                    INSERT INTO saques (user_id, valor, tipo, status, created_at)
                    VALUES (?, ?, 'credito', 'processando', NOW())
                ");
                if ($stmt->execute([$promoter_id, $valor])) {
                    $sucesso = '<i class="fas fa-glass-cheers"></i> Bônus de R$ ' . number_format($valor, 2, ',', '.') . ' creditado como CONSUMAÇÃO!';
                }
            }
        } catch (PDOException $e) {
            $erro = 'Erro ao lançar bônus: ' . $e->getMessage();
        }
    } else {
        $erro = 'Valor inválido.';
    }
}

// Buscar saldos
$stmt = $pdo->prepare("SELECT COALESCE(SUM(valor), 0) as total FROM comissoes WHERE user_id = ? AND status = 'disponivel'");
$stmt->execute([$promoter_id]);
$saldo_disponivel = $stmt->fetch()['total'];

$stmt = $pdo->prepare("SELECT COALESCE(SUM(valor), 0) as total FROM comissoes WHERE user_id = ? AND status = 'solicitado'");
$stmt->execute([$promoter_id]);
$saldo_solicitado = $stmt->fetch()['total'];

$stmt = $pdo->prepare("SELECT COALESCE(SUM(valor), 0) as total FROM comissoes WHERE user_id = ? AND status = 'pago'");
$stmt->execute([$promoter_id]);
$total_recebido = $stmt->fetch()['total'];

// Buscar créditos de consumação aprovados - CORRIGIDO
$stmt = $pdo->prepare("
    SELECT COALESCE(SUM(valor), 0) as total 
    FROM saques 
    WHERE user_id = ? AND tipo = 'credito' AND status = 'processando'
");
$stmt->execute([$promoter_id]);
$credito_consumacao = $stmt->fetch()['total'];

// Buscar eventos do promoter com estatísticas detalhadas
$stmt = $pdo->prepare("
    SELECT e.*, pe.link_exclusivo,
    (SELECT COUNT(*) FROM convidados c WHERE c.promoter_id = ? AND c.evento_id = e.id) as total_convidados,
    (SELECT COUNT(*) FROM convidados c WHERE c.promoter_id = ? AND c.evento_id = e.id AND c.checkin = 1) as total_checkins,
    (SELECT c2.valor FROM comissoes c2 WHERE c2.user_id = ? AND c2.evento_id = e.id LIMIT 1) as comissao_evento
    FROM eventos e
    INNER JOIN produtor_eventos pe ON e.id = pe.evento_id
    WHERE pe.user_id = ?
    ORDER BY e.data DESC
");
$stmt->execute([$promoter_id, $promoter_id, $promoter_id, $promoter_id]);
$eventos = $stmt->fetchAll();

// Buscar comissões detalhadas
$stmt = $pdo->prepare("
    SELECT c.*, e.nome as evento_nome, e.data as evento_data
    FROM comissoes c
    LEFT JOIN eventos e ON c.evento_id = e.id
    WHERE c.user_id = ?
    ORDER BY c.created_at DESC
");
$stmt->execute([$promoter_id]);
$comissoes = $stmt->fetchAll();

// Buscar saques
$stmt = $pdo->prepare("SELECT * FROM saques WHERE user_id = ? ORDER BY created_at DESC LIMIT 10");
$stmt->execute([$promoter_id]);
$saques = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Perfil - <?= htmlspecialchars($promoter['nome']) ?></title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        
        :root[data-theme="dark"] {
            --bg-primary: #000000;
            --bg-secondary: #1a1a1a;
            --bg-card: #2a2a2a;
            --color-primary: #FFD700;
            --color-text: #ffffff;
            --color-text-secondary: #999999;
            --border-color: #333333;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: var(--bg-secondary);
            color: var(--color-text);
        }
        
        .navbar {
            background: var(--bg-primary);
            border-bottom: 2px solid var(--border-color);
            padding: 15px 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            position: sticky;
            top: 0;
            z-index: 100;
        }
        
        .navbar-brand {
            font-size: 24px;
            font-weight: bold;
            color: var(--color-primary);
        }
        
        .navbar-menu {
            display: flex;
            gap: 10px;
            align-items: center;
        }
        
        .nav-link {
            color: var(--color-text);
            text-decoration: none;
            padding: 8px 15px;
            border-radius: 8px;
        }
        
        .nav-link:hover {
            background: var(--bg-card);
            color: var(--color-primary);
        }
        
        .mobile-menu-toggle {
            display: none;
            background: none;
            border: none;
            color: var(--color-text);
            font-size: 24px;
            cursor: pointer;
        }
        
        .container {
            max-width: 1600px;
            margin: 0 auto;
            padding: 30px 20px;
        }
        
        .alert {
            padding: 15px 20px;
            border-radius: 10px;
            margin-bottom: 20px;
        }
        
        .alert-success {
            background: rgba(0, 200, 81, 0.1);
            border: 2px solid #00C851;
            color: #00C851;
        }
        
        .alert-error {
            background: rgba(255, 68, 68, 0.1);
            border: 2px solid #ff4444;
            color: #ff4444;
        }
        
        .page-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 30px;
        }
        
        .page-title {
            font-size: 32px;
            font-weight: bold;
            color: var(--color-primary);
        }
        
        .btn {
            padding: 12px 24px;
            border: none;
            border-radius: 10px;
            font-size: 14px;
            font-weight: 600;
            cursor: pointer;
            text-decoration: none;
            display: inline-block;
            transition: all 0.3s;
        }
        
        .btn-primary {
            background: var(--color-primary);
            color: #000;
        }
        
        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(255, 215, 0, 0.3);
        }
        
        .btn-secondary {
            background: var(--bg-card);
            color: var(--color-text);
            border: 1px solid var(--border-color);
        }
        
        .btn-secondary:hover {
            background: var(--bg-secondary);
        }
        
        .saldos-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }
        
        .saldo-card {
            background: linear-gradient(135deg, var(--bg-card) 0%, rgba(255, 215, 0, 0.1) 100%);
            border: 2px solid var(--border-color);
            border-radius: 15px;
            padding: 20px;
            text-align: center;
        }
        
        .saldo-card.consumacao {
            background: linear-gradient(135deg, var(--bg-card) 0%, rgba(0, 200, 81, 0.1) 100%);
        }
        
        .saldo-label {
            font-size: 14px;
            color: var(--color-text-secondary);
            margin-bottom: 10px;
        }
        
        .saldo-valor {
            font-size: 28px;
            font-weight: bold;
            color: var(--color-primary);
        }
        
        .card {
            background: var(--bg-card);
            border: 1px solid var(--border-color);
            border-radius: 15px;
            padding: 30px;
            margin-bottom: 30px;
        }
        
        .card-title {
            font-size: 20px;
            font-weight: bold;
            color: var(--color-primary);
            margin-bottom: 20px;
            padding-bottom: 15px;
            border-bottom: 2px solid var(--border-color);
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        .form-group label {
            display: block;
            margin-bottom: 8px;
            font-weight: 600;
            color: var(--color-text);
        }
        
        .form-group input,
        .form-group select,
        .form-group textarea {
            width: 100%;
            padding: 12px;
            background: var(--bg-secondary);
            border: 2px solid var(--border-color);
            border-radius: 8px;
            color: var(--color-text);
            font-size: 14px;
        }
        
        .form-group input:focus,
        .form-group select:focus,
        .form-group textarea:focus {
            outline: none;
            border-color: var(--color-primary);
        }
        
        .grid-2 {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 20px;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
        }
        
        th, td {
            padding: 15px;
            text-align: left;
            border-bottom: 1px solid var(--border-color);
        }
        
        th {
            background: var(--bg-secondary);
            font-weight: 600;
            color: var(--color-primary);
        }
        
        .badge {
            padding: 5px 12px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: 600;
        }
        
        .badge-success {
            background: rgba(0, 200, 81, 0.2);
            color: #00C851;
        }
        
        .badge-warning {
            background: rgba(255, 193, 7, 0.2);
            color: #FFC107;
        }
        
        .evento-item {
            background: var(--bg-secondary);
            border: 1px solid var(--border-color);
            border-radius: 10px;
            padding: 20px;
            margin-bottom: 15px;
        }
        
        .evento-nome {
            font-size: 18px;
            font-weight: bold;
            color: var(--color-text);
            margin-bottom: 10px;
        }
        
        .evento-stats {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
            gap: 15px;
            margin-top: 15px;
        }
        
        .stat-box {
            background: var(--bg-card);
            border: 1px solid var(--border-color);
            border-radius: 8px;
            padding: 15px;
            text-align: center;
        }
        
        .stat-value {
            font-size: 24px;
            font-weight: bold;
            color: var(--color-primary);
            margin-bottom: 5px;
        }
        
        .stat-label {
            font-size: 11px;
            color: var(--color-text-secondary);
            text-transform: uppercase;
        }
        
        @media (max-width: 768px) {
            .grid-2 {
                grid-template-columns: 1fr;
            }
            
            .saldos-grid {
                grid-template-columns: repeat(2, 1fr);
            }
            
            .evento-stats {
                grid-template-columns: repeat(2, 1fr);
            }
        }
    </style>
</head>
<body>
    <nav class="navbar">
        <div class="navbar-brand">👤 Perfil do Promoter</div>
        <div class="navbar-menu">
            <a href="admin_usuarios.php" class="btn btn-secondary">← Voltar</a>
            <a href="dashboard.php" class="btn btn-primary">Dashboard</a>
        </div>
    </nav>
    
    <div class="container">
        <?php if ($sucesso): ?>
            <div class="alert alert-success"><?= $sucesso ?></div>
        <?php endif; ?>
        
        <?php if ($erro): ?>
            <div class="alert alert-error"><?= $erro ?></div>
        <?php endif; ?>
        
        <div class="page-header" style="display: flex; align-items: center; gap: 20px;">
            <?php
            $foto_perfil = !empty($promoter['foto_perfil']) && file_exists($promoter['foto_perfil'])
                ? $promoter['foto_perfil']
                : 'assets/default-avatar.png';
            ?>
            <img src="<?= htmlspecialchars($foto_perfil) ?>"
                 alt="Foto de <?= htmlspecialchars($promoter['nome']) ?>"
                 style="width: 100px; height: 100px; border-radius: 50%; border: 3px solid var(--color-gold); object-fit: cover;"
                 onerror="this.src='assets/default-avatar.png'">
            <div>
                <h1 class="page-title"><?= htmlspecialchars($promoter['nome']) ?></h1>
                <p style="color: var(--color-text-secondary); margin-top: 5px;">
                    <?= htmlspecialchars($promoter['email']) ?> | <?= htmlspecialchars($promoter['telefone']) ?>
                </p>
            </div>
        </div>
        
        <!-- Cards de Saldo -->
        <div class="saldos-grid">
            <div class="saldo-card">
                <div class="saldo-label"><i class="fas fa-money-bill-wave"></i> Saldo Disponível</div>
                <div class="saldo-valor"><?= formatarMoeda($saldo_disponivel) ?></div>
            </div>
            
            <div class="saldo-card">
                <div class="saldo-label">⏳ Saldo Solicitado</div>
                <div class="saldo-valor"><?= formatarMoeda($saldo_solicitado) ?></div>
            </div>
            
            <div class="saldo-card">
                <div class="saldo-label"><i class="fas fa-check-circle"></i> Total Recebido</div>
                <div class="saldo-valor"><?= formatarMoeda($total_recebido) ?></div>
            </div>
            
            <div class="saldo-card consumacao">
                <div class="saldo-label"><i class="fas fa-glass-cheers"></i> Crédito Consumação</div>
                <div class="saldo-valor"><?= formatarMoeda($credito_consumacao) ?></div>
            </div>
            
            <div class="saldo-card">
                <div class="saldo-label">🎪 Eventos Ativos</div>
                <div class="saldo-valor"><?= count($eventos) ?></div>
            </div>
        </div>
        
        <!-- Lançar Bônus -->
        <div class="card">
            <div class="card-title">🎁 Lançar Bônus</div>
            
            <form method="POST">
                <div class="grid-2">
                    <div class="form-group">
                        <label>Valor do Bônus (R$)</label>
                        <input type="number" name="valor_bonus" step="0.01" min="0.01" required placeholder="0,00">
                    </div>
                    
                    <div class="form-group">
                        <label>Tipo de Bônus</label>
                        <select name="tipo_bonus" required>
                            <option value="dinheiro"><i class="fas fa-money-bill-wave"></i> Dinheiro (Saldo Disponível)</option>
                            <option value="consumacao"><i class="fas fa-glass-cheers"></i> Consumação (Crédito Evento)</option>
                        </select>
                    </div>
                </div>
                
                <div class="form-group">
                    <label>Descrição (opcional)</label>
                    <textarea name="descricao" rows="2" placeholder="Motivo do bônus..."></textarea>
                </div>
                
                <button type="submit" name="lancar_bonus" class="btn btn-primary">
                    🎁 Lançar Bônus
                </button>
            </form>
        </div>
        
        <!-- Eventos do Promoter -->
        <div class="card">
            <div class="card-title">🎪 Eventos Participantes (<?= count($eventos) ?>)</div>
            
            <?php if (count($eventos) > 0): ?>
                <?php foreach ($eventos as $evt): 
                    $taxa = $evt['total_convidados'] > 0 ? 
                        round(($evt['total_checkins'] / $evt['total_convidados']) * 100, 1) : 0;
                ?>
                    <div class="evento-item">
                        <div class="evento-nome"><?= htmlspecialchars($evt['nome']) ?></div>
                        <div style="font-size: 13px; color: var(--color-text-secondary);">
                            <i class="fas fa-calendar-alt"></i> <?= formatarData($evt['data']) ?> | <i class="fas fa-money-bill-wave"></i> Comissão: <?= formatarMoeda($evt['valor_comissao']) ?>/check-in
                        </div>
                        
                        <div class="evento-stats">
                            <div class="stat-box">
                                <div class="stat-value"><?= $evt['total_convidados'] ?></div>
                                <div class="stat-label"><i class="fas fa-clipboard-list"></i> PESSOAS NO LINK</div>
                            </div>
                            <div class="stat-box">
                                <div class="stat-value"><?= $evt['total_checkins'] ?></div>
                                <div class="stat-label"><i class="fas fa-check-circle"></i> CHECK-INS FEITOS</div>
                            </div>
                            <div class="stat-box">
                                <div class="stat-value"><?= $taxa ?>%</div>
                                <div class="stat-label"><i class="fas fa-chart-bar"></i> TAXA CONVERSÃO</div>
                            </div>
                            <div class="stat-box">
                                <div class="stat-value"><?= formatarMoeda($evt['comissao_evento'] ?? 0) ?></div>
                                <div class="stat-label"><i class="fas fa-money-bill-wave"></i> COMISSÃO</div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php else: ?>
                <p style="text-align: center; color: var(--color-text-secondary); padding: 40px;">
                    Nenhum evento cadastrado
                </p>
            <?php endif; ?>
        </div>
        
        <!-- Histórico de Comissões -->
        <div class="card">
            <div class="card-title"><i class="fas fa-money-bill-wave"></i> Histórico de Comissões</div>
            
            <table>
                <thead>
                    <tr>
                        <th>Evento/Descrição</th>
                        <th>Data</th>
                        <th>Convidados</th>
                        <th>Check-ins</th>
                        <th>Valor</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($comissoes as $com): ?>
                        <tr>
                            <td>
                                <?php if ($com['evento_id'] == 0): ?>
                                    <strong style="color: var(--color-primary);">🎁 BÔNUS</strong>
                                <?php else: ?>
                                    <?= htmlspecialchars($com['evento_nome']) ?>
                                <?php endif; ?>
                            </td>
                            <td><?= formatarData($com['created_at']) ?></td>
                            <td><?= $com['convidados_total'] ?></td>
                            <td><?= $com['convidados_checkin'] ?></td>
                            <td style="font-weight: bold; color: var(--color-primary);">
                                <?= formatarMoeda($com['valor']) ?>
                            </td>
                            <td>
                                <?php if ($com['status'] === 'disponivel'): ?>
                                    <span class="badge badge-success">Disponível</span>
                                <?php elseif ($com['status'] === 'solicitado'): ?>
                                    <span class="badge badge-warning">Solicitado</span>
                                <?php else: ?>
                                    <span class="badge" style="background: #17a2b8;">Pago</span>
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
        
        <!-- Histórico de Saques -->
        <div class="card">
            <div class="card-title"><i class="fas fa-clipboard-list"></i> Últimos Saques</div>
            
            <table>
                <thead>
                    <tr>
                        <th>Data</th>
                        <th>Tipo</th>
                        <th>Valor</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (count($saques) > 0): ?>
                        <?php foreach ($saques as $saque): ?>
                            <tr>
                                <td><?= formatarDataHora($saque['created_at']) ?></td>
                                <td>
                                    <?= $saque['tipo'] === 'pix' ? '🦠 PIX' : '💳 Crédito' ?>
                                </td>
                                <td style="font-weight: bold;"><?= formatarMoeda($saque['valor']) ?></td>
                                <td>
                                    <?php
                                    $status_badges = [
                                        'pendente' => '<span class="badge badge-warning">Pendente</span>',
                                        'processando' => '<span class="badge" style="background: #17a2b8;">Processando</span>',
                                        'concluido' => '<span class="badge badge-success">Pago</span>',
                                        'cancelado' => '<span class="badge" style="background: #dc3545;">Cancelado</span>'
                                    ];
                                    echo $status_badges[$saque['status']] ?? $saque['status'];
                                    ?>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="4" style="text-align: center; color: var(--color-text-secondary); padding: 40px;">
                                Nenhum saque realizado
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
    
    <script>
        const savedTheme = localStorage.getItem('theme') || 'dark';
        document.documentElement.setAttribute('data-theme', savedTheme);
        
        function toggleMenu() {
            document.getElementById('navMenu').classList.toggle('active');
        }
    </script>
    </div><!-- /.main-content -->
    <script src="assets/js/sidebar.js"></script>
</body>
</html>