<?php
// Sidebar compartilhada - Sistema Promoters
// Menu lateral estilo WordPress para todas as páginas

// Verificar se $usuario e $role estão definidos
if (!isset($usuario) || !isset($role)) {
    $stmt = $pdo->prepare("SELECT * FROM users WHERE id = ?");
    $stmt->execute([$_SESSION['user_id']]);
    $usuario = $stmt->fetch();
    $role = $_SESSION['role'];
}

// Foto de perfil padrão se não existir
$foto_perfil = !empty($usuario['foto_perfil']) && file_exists($usuario['foto_perfil'])
    ? $usuario['foto_perfil']
    : 'assets/default-avatar.png';

// Contar check-ins de eventos ABERTOS (apenas para admin)
$checkins_evento_ativo = 0;
$aniversariantes_mes = 0;
if ($role === 'admin') {
    $stmt = $pdo->query("
        SELECT COUNT(DISTINCT c.id) as total_checkins
        FROM convidados c
        INNER JOIN eventos e ON c.evento_id = e.id
        WHERE e.status = 'aberto' AND c.checkin = 1
    ");
    $result = $stmt->fetch();
    $checkins_evento_ativo = $result['total_checkins'] ?? 0;

    // Contar aniversariantes do mês que ainda não receberam mensagem
    try {
        $mes_atual = intval(date('m'));
        $ano_atual = intval(date('Y'));
        $stmt = $pdo->prepare("
            SELECT COUNT(*) as total
            FROM convidados c
            LEFT JOIN aniversarios_enviados ae ON c.id = ae.convidado_id AND ae.ano = ?
            WHERE c.data_nascimento IS NOT NULL
              AND MONTH(c.data_nascimento) = ?
              AND ae.id IS NULL
        ");
        $stmt->execute([$ano_atual, $mes_atual]);
        $result = $stmt->fetch();
        $aniversariantes_mes = $result['total'] ?? 0;
    } catch (PDOException $e) {
        // Tabela ainda não existe, ignorar
        $aniversariantes_mes = 0;
    }
}

// Determinar página atual para marcar como ativa
$current_page = basename($_SERVER['PHP_SELF']);
?>

<!-- Sidebar -->
<div class="sidebar" id="sidebar">
    <!-- Logo -->
    <div class="sidebar-logo">
        <i class="fas fa-gem"></i>
        <span class="sidebar-logo-text">PromoTaal</span>
    </div>

    <!-- User Profile -->
    <div class="sidebar-user">
        <img src="<?= htmlspecialchars($foto_perfil) ?>"
             alt="<?= htmlspecialchars($usuario['nome']) ?>"
             class="sidebar-user-avatar"
             onerror="this.src='assets/default-avatar.png'">
        <div class="sidebar-user-info">
            <div class="sidebar-user-name">
                <?= htmlspecialchars(explode(' ', $usuario['nome'])[0]) ?>
            </div>
            <div class="sidebar-user-role">
                <?php
                if ($role === 'admin') echo 'Administrador';
                elseif ($role === 'produtor') echo 'Produtor';
                elseif ($role === 'gerente') echo 'Gerente';
                else echo 'Promoter';
                ?>
            </div>
        </div>
    </div>

    <!-- Menu Items -->
    <nav class="sidebar-nav">
        <!-- Dashboard - Comum para todos -->
        <a href="dashboard.php" class="sidebar-link <?= $current_page === 'dashboard.php' ? 'active' : '' ?>">
            <i class="fas fa-home"></i>
            <span class="sidebar-link-text">Dashboard</span>
        </a>

        <?php if ($role === 'admin'): ?>
            <!-- Menu Admin -->
            <a href="admin_eventos.php" class="sidebar-link <?= $current_page === 'admin_eventos.php' ? 'active' : '' ?>">
                <i class="fas fa-calendar-alt"></i>
                <span class="sidebar-link-text">Eventos</span>
            </a>

            <a href="admin_usuarios.php" class="sidebar-link <?= $current_page === 'admin_usuarios.php' ? 'active' : '' ?>">
                <i class="fas fa-users"></i>
                <span class="sidebar-link-text">Promoters</span>
            </a>

            <a href="admin_convidados.php" class="sidebar-link <?= $current_page === 'admin_convidados.php' ? 'active' : '' ?>">
                <i class="fas fa-list"></i>
                <span class="sidebar-link-text">Convidados</span>
            </a>

            <a href="admin_checkin.php" class="sidebar-link <?= $current_page === 'admin_checkin.php' ? 'active' : '' ?>">
                <i class="fas fa-qrcode"></i>
                <span class="sidebar-link-text">Check-in</span>
                <span class="sidebar-badge" data-type="checkins" style="<?= $checkins_evento_ativo <= 0 ? 'display: none;' : '' ?>">
                    <?= $checkins_evento_ativo ?>
                </span>
            </a>

            <a href="admin_saques.php" class="sidebar-link <?= $current_page === 'admin_saques.php' ? 'active' : '' ?>">
                <i class="fas fa-money-bill-wave"></i>
                <span class="sidebar-link-text">Saques</span>
            </a>

            <a href="admin_relatorios.php" class="sidebar-link <?= $current_page === 'admin_relatorios.php' ? 'active' : '' ?>">
                <i class="fas fa-chart-bar"></i>
                <span class="sidebar-link-text">Relatórios</span>
            </a>

            <a href="admin_aniversarios.php" class="sidebar-link <?= $current_page === 'admin_aniversarios.php' ? 'active' : '' ?>">
                <i class="fas fa-birthday-cake"></i>
                <span class="sidebar-link-text">Aniversários</span>
                <span class="sidebar-badge" data-type="aniversarios" style="<?= $aniversariantes_mes <= 0 ? 'display: none;' : '' ?>">
                    <?= $aniversariantes_mes ?>
                </span>
            </a>

            <a href="admin_mensagens.php" class="sidebar-link <?= $current_page === 'admin_mensagens.php' ? 'active' : '' ?>">
                <i class="fas fa-envelope"></i>
                <span class="sidebar-link-text">Mensagens</span>
                <span class="sidebar-badge" data-type="mensagens" style="<?= (!isset($usuario['mensagens_nao_lidas']) || $usuario['mensagens_nao_lidas'] <= 0) ? 'display: none;' : '' ?>">
                    <?= isset($usuario['mensagens_nao_lidas']) ? $usuario['mensagens_nao_lidas'] : 0 ?>
                </span>
            </a>

            <a href="notificacoes.php" class="sidebar-link <?= $current_page === 'notificacoes.php' ? 'active' : '' ?>">
                <i class="fas fa-bell"></i>
                <span class="sidebar-link-text">Notificações</span>
                <span class="sidebar-badge" data-type="notificacoes" style="<?= (!isset($usuario['notificacoes_nao_lidas']) || $usuario['notificacoes_nao_lidas'] <= 0) ? 'display: none;' : '' ?>">
                    <?= isset($usuario['notificacoes_nao_lidas']) ? $usuario['notificacoes_nao_lidas'] : 0 ?>
                </span>
            </a>

            <a href="configuracoes.php" class="sidebar-link <?= $current_page === 'configuracoes.php' ? 'active' : '' ?>">
                <i class="fas fa-cog"></i>
                <span class="sidebar-link-text">Configurações</span>
            </a>

        <?php elseif ($role === 'produtor'): ?>
            <!-- Menu Produtor -->
            <a href="produtor_eventos.php" class="sidebar-link <?= $current_page === 'produtor_eventos.php' ? 'active' : '' ?>">
                <i class="fas fa-calendar-alt"></i>
                <span class="sidebar-link-text">Eventos</span>
            </a>

            <a href="produtor_listas.php" class="sidebar-link <?= $current_page === 'produtor_listas.php' ? 'active' : '' ?>">
                <i class="fas fa-list"></i>
                <span class="sidebar-link-text">Minhas Listas</span>
            </a>

            <a href="produtor_financeiro.php" class="sidebar-link <?= $current_page === 'produtor_financeiro.php' ? 'active' : '' ?>">
                <i class="fas fa-wallet"></i>
                <span class="sidebar-link-text">Financeiro</span>
            </a>

            <a href="mensagens.php" class="sidebar-link <?= $current_page === 'mensagens.php' ? 'active' : '' ?>">
                <i class="fas fa-envelope"></i>
                <span class="sidebar-link-text">Mensagens</span>
                <span class="sidebar-badge" data-type="mensagens" style="<?= (!isset($usuario['mensagens_nao_lidas']) || $usuario['mensagens_nao_lidas'] <= 0) ? 'display: none;' : '' ?>">
                    <?= isset($usuario['mensagens_nao_lidas']) ? $usuario['mensagens_nao_lidas'] : 0 ?>
                </span>
            </a>

            <a href="notificacoes.php" class="sidebar-link <?= $current_page === 'notificacoes.php' ? 'active' : '' ?>">
                <i class="fas fa-bell"></i>
                <span class="sidebar-link-text">Notificações</span>
                <span class="sidebar-badge" data-type="notificacoes" style="<?= (!isset($usuario['notificacoes_nao_lidas']) || $usuario['notificacoes_nao_lidas'] <= 0) ? 'display: none;' : '' ?>">
                    <?= isset($usuario['notificacoes_nao_lidas']) ? $usuario['notificacoes_nao_lidas'] : 0 ?>
                </span>
            </a>

        <?php else: ?>
            <!-- Menu Promoter -->
            <a href="eventos.php" class="sidebar-link <?= $current_page === 'eventos.php' ? 'active' : '' ?>">
                <i class="fas fa-calendar-alt"></i>
                <span class="sidebar-link-text">Eventos</span>
            </a>

            <a href="minhas_listas.php" class="sidebar-link <?= $current_page === 'minhas_listas.php' ? 'active' : '' ?>">
                <i class="fas fa-list"></i>
                <span class="sidebar-link-text">Minhas Listas</span>
            </a>

            <a href="financeiro.php" class="sidebar-link <?= $current_page === 'financeiro.php' ? 'active' : '' ?>">
                <i class="fas fa-wallet"></i>
                <span class="sidebar-link-text">Financeiro</span>
            </a>

            <a href="ranking.php" class="sidebar-link <?= $current_page === 'ranking.php' ? 'active' : '' ?>">
                <i class="fas fa-trophy"></i>
                <span class="sidebar-link-text">Ranking</span>
            </a>

            <a href="mensagens.php" class="sidebar-link <?= $current_page === 'mensagens.php' ? 'active' : '' ?>">
                <i class="fas fa-envelope"></i>
                <span class="sidebar-link-text">Mensagens</span>
                <span class="sidebar-badge" data-type="mensagens" style="<?= (!isset($usuario['mensagens_nao_lidas']) || $usuario['mensagens_nao_lidas'] <= 0) ? 'display: none;' : '' ?>">
                    <?= isset($usuario['mensagens_nao_lidas']) ? $usuario['mensagens_nao_lidas'] : 0 ?>
                </span>
            </a>

            <a href="notificacoes.php" class="sidebar-link <?= $current_page === 'notificacoes.php' ? 'active' : '' ?>">
                <i class="fas fa-bell"></i>
                <span class="sidebar-link-text">Notificações</span>
                <span class="sidebar-badge" data-type="notificacoes" style="<?= (!isset($usuario['notificacoes_nao_lidas']) || $usuario['notificacoes_nao_lidas'] <= 0) ? 'display: none;' : '' ?>">
                    <?= isset($usuario['notificacoes_nao_lidas']) ? $usuario['notificacoes_nao_lidas'] : 0 ?>
                </span>
            </a>
        <?php endif; ?>

        <!-- Seção inferior - Disponível para todos -->
        <div class="sidebar-separator"></div>

        <a href="meu_perfil.php" class="sidebar-link <?= $current_page === 'meu_perfil.php' ? 'active' : '' ?>">
            <i class="fas fa-user-circle"></i>
            <span class="sidebar-link-text">Meu Perfil</span>
        </a>

        <a href="logout.php" class="sidebar-link sidebar-link-danger">
            <i class="fas fa-sign-out-alt"></i>
            <span class="sidebar-link-text">Sair</span>
        </a>
    </nav>

    <!-- Rodapé com informações -->
    <div class="sidebar-footer">
        <div class="sidebar-footer-info">
            <div class="sidebar-footer-line">Desenvolvido por Alerson Araujo</div>
            <div class="sidebar-footer-line">Licenciado para Espaço Taal</div>
            <div class="sidebar-footer-line">Versão 3.0</div>
        </div>
    </div>

    <!-- Toggle Button (apenas mobile) -->
    <button class="sidebar-toggle" id="sidebarToggle" onclick="toggleSidebar()">
        <i class="fas fa-bars"></i>
    </button>
</div>

<!-- Overlay for mobile -->
<div class="sidebar-overlay" id="sidebarOverlay" onclick="toggleSidebar()"></div>

<!-- Main Content Wrapper -->
<div class="main-content" id="mainContent">
    <!-- Topbar for mobile -->
    <div class="mobile-topbar">
        <button class="mobile-menu-btn" onclick="toggleSidebar()">
            <i class="fas fa-bars"></i>
        </button>
        <div class="mobile-topbar-logo">
            <i class="fas fa-gem"></i>
            PromoTaal
        </div>
        <div class="mobile-topbar-avatar">
            <img src="<?= htmlspecialchars($foto_perfil) ?>"
                 alt="<?= htmlspecialchars($usuario['nome']) ?>"
                 onerror="this.src='assets/default-avatar.png'">
        </div>
    </div>

<!-- CSS e JavaScript do Sistema de Notificações v3.0 -->
<?php if (!isset($disable_notificacoes_system)): ?>
<link rel="stylesheet" href="assets/css/notificacoes.css">
<script src="assets/js/notificacoes.js"></script>
<?php endif; ?>
