<?php
// checkins_live.php - Endpoint AJAX para buscar check-ins em tempo real
require_once 'config.php';
verificarRole(['admin', 'gerente']);

header('Content-Type: application/json');

// Verificar se há um evento aberto
if (!isset($_SESSION['evento_checkin_aberto'])) {
    echo json_encode([
        'success' => false,
        'evento_aberto' => false
    ]);
    exit;
}

$evento_id = intval($_SESSION['evento_checkin_aberto']);

// Buscar informações do evento
$stmt = $pdo->prepare("SELECT id, nome FROM eventos WHERE id = ?");
$stmt->execute([$evento_id]);
$evento = $stmt->fetch();

if (!$evento) {
    echo json_encode([
        'success' => false,
        'evento_aberto' => false
    ]);
    exit;
}

// Buscar últimos 10 check-ins do evento aberto
$stmt = $pdo->prepare("
    SELECT
        c.nome as convidado_nome,
        c.whatsapp,
        c.checkin_data,
        e.nome as evento_nome,
        u_promoter.nome as promoter_nome,
        u_admin.nome as admin_nome
    FROM convidados c
    INNER JOIN eventos e ON c.evento_id = e.id
    INNER JOIN users u_promoter ON c.promoter_id = u_promoter.id
    LEFT JOIN users u_admin ON c.checkin_by_admin_id = u_admin.id
    WHERE c.evento_id = ? AND c.checkin = 1
    ORDER BY c.checkin_data DESC
    LIMIT 10
");
$stmt->execute([$evento_id]);
$checkins = $stmt->fetchAll();

// Contar total de check-ins hoje para este evento
$stmt = $pdo->prepare("
    SELECT COUNT(*) as total
    FROM convidados
    WHERE evento_id = ? AND checkin = 1 AND DATE(checkin_data) = CURDATE()
");
$stmt->execute([$evento_id]);
$total_hoje = $stmt->fetch()['total'];

echo json_encode([
    'success' => true,
    'evento_aberto' => true,
    'evento' => $evento,
    'checkins' => $checkins,
    'total_hoje' => $total_hoje
]);
