<?php
// debug_comissoes.php - Script para diagnosticar problema de comissões
require_once 'config.php';
require_once 'functions.php';

// ID do promoter e evento para testar (você pode mudar isso)
$promoter_id = isset($_GET['promoter']) ? intval($_GET['promoter']) : 0;
$evento_id = isset($_GET['evento']) ? intval($_GET['evento']) : 0;

if (!$promoter_id || !$evento_id) {
    echo "<h1>Debug de Comissões</h1>";
    echo "<p>Use: debug_comissoes.php?promoter=ID&evento=ID</p>";

    // Listar promoters
    echo "<h2>Promoters disponíveis:</h2>";
    $stmt = $pdo->query("SELECT id, nome, email FROM users WHERE role = 'user' ORDER BY nome");
    $promoters = $stmt->fetchAll();
    echo "<ul>";
    foreach ($promoters as $p) {
        echo "<li>ID: {$p['id']} - {$p['nome']} ({$p['email']})</li>";
    }
    echo "</ul>";

    // Listar eventos
    echo "<h2>Eventos disponíveis:</h2>";
    $stmt = $pdo->query("SELECT id, nome, valor_comissao, minimo_lista FROM eventos ORDER BY data DESC LIMIT 10");
    $eventos = $stmt->fetchAll();
    echo "<ul>";
    foreach ($eventos as $e) {
        echo "<li>ID: {$e['id']} - {$e['nome']} (Comissão: R$ {$e['valor_comissao']}, Mínimo: {$e['minimo_lista']})</li>";
    }
    echo "</ul>";
    exit;
}

echo "<h1>Diagnóstico de Comissões</h1>";
echo "<hr>";

// Buscar promoter
$stmt = $pdo->prepare("SELECT * FROM users WHERE id = ?");
$stmt->execute([$promoter_id]);
$promoter = $stmt->fetch();

echo "<h2>Promoter:</h2>";
echo "<pre>";
print_r($promoter);
echo "</pre>";

// Buscar evento
$stmt = $pdo->prepare("SELECT * FROM eventos WHERE id = ?");
$stmt->execute([$evento_id]);
$evento = $stmt->fetch();

echo "<h2>Evento:</h2>";
echo "<pre>";
print_r($evento);
echo "</pre>";

// Contar convidados
$stmt = $pdo->prepare("
    SELECT
        COUNT(*) as total,
        SUM(CASE WHEN checkin = 1 THEN 1 ELSE 0 END) as checkins
    FROM convidados
    WHERE promoter_id = ? AND evento_id = ?
");
$stmt->execute([$promoter_id, $evento_id]);
$stats = $stmt->fetch();

echo "<h2>Estatísticas:</h2>";
echo "<ul>";
echo "<li>Total de convidados: {$stats['total']}</li>";
echo "<li>Total de check-ins: {$stats['checkins']}</li>";
echo "<li>Mínimo necessário: {$evento['minimo_lista']}</li>";
echo "<li>Atingiu mínimo? " . ($stats['total'] >= $evento['minimo_lista'] ? "✅ SIM" : "❌ NÃO") . "</li>";
echo "</ul>";

// Listar convidados
$stmt = $pdo->prepare("SELECT * FROM convidados WHERE promoter_id = ? AND evento_id = ? ORDER BY id DESC");
$stmt->execute([$promoter_id, $evento_id]);
$convidados = $stmt->fetchAll();

echo "<h2>Convidados:</h2>";
echo "<table border='1' cellpadding='5'>";
echo "<tr><th>ID</th><th>Nome</th><th>Check-in</th><th>Data Check-in</th></tr>";
foreach ($convidados as $c) {
    echo "<tr>";
    echo "<td>{$c['id']}</td>";
    echo "<td>{$c['nome']}</td>";
    echo "<td>" . ($c['checkin'] ? "✅ SIM" : "❌ NÃO") . "</td>";
    echo "<td>" . ($c['checkin_data'] ?? '-') . "</td>";
    echo "</tr>";
}
echo "</table>";

// Buscar comissões
$stmt = $pdo->prepare("SELECT * FROM comissoes WHERE user_id = ? AND evento_id = ? ORDER BY id DESC");
$stmt->execute([$promoter_id, $evento_id]);
$comissoes = $stmt->fetchAll();

echo "<h2>Comissões:</h2>";
if (count($comissoes) > 0) {
    echo "<table border='1' cellpadding='5'>";
    echo "<tr><th>ID</th><th>Valor</th><th>Check-ins</th><th>Status</th><th>Criada em</th></tr>";
    foreach ($comissoes as $com) {
        echo "<tr>";
        echo "<td>{$com['id']}</td>";
        echo "<td>R$ " . number_format($com['valor'], 2, ',', '.') . "</td>";
        echo "<td>{$com['convidados_checkin']}</td>";
        echo "<td>{$com['status']}</td>";
        echo "<td>{$com['created_at']}</td>";
        echo "</tr>";
    }
    echo "</table>";
} else {
    echo "<p style='color: red; font-weight: bold;'>❌ NENHUMA COMISSÃO ENCONTRADA!</p>";
}

// Calcular o que deveria ser
echo "<h2>Cálculo Esperado:</h2>";
$total_checkins = intval($stats['checkins']);
$valor_esperado = $total_checkins * floatval($evento['valor_comissao']);
echo "<ul>";
echo "<li>Total de check-ins: {$total_checkins}</li>";
echo "<li>Valor por check-in: R$ " . number_format($evento['valor_comissao'], 2, ',', '.') . "</li>";
echo "<li>Valor esperado: R$ " . number_format($valor_esperado, 2, ',', '.') . "</li>";
echo "</ul>";

// Verificar logs
echo "<h2>Logs recentes:</h2>";
$log_file = __DIR__ . '/logs/erros.log';
if (file_exists($log_file)) {
    $logs = file($log_file);
    $logs = array_slice($logs, -20); // Últimas 20 linhas
    echo "<pre>";
    foreach ($logs as $log) {
        if (strpos($log, 'atualizarComissoes') !== false || strpos($log, 'Comissão') !== false) {
            echo htmlspecialchars($log);
        }
    }
    echo "</pre>";
} else {
    echo "<p>Arquivo de log não encontrado</p>";
}

// Botão para forçar atualização
echo "<hr>";
echo "<h2>Ações:</h2>";
echo "<form method='POST'>";
echo "<button type='submit' name='forcar_atualizacao' style='padding: 10px 20px; background: #FFD700; border: none; cursor: pointer;'>";
echo "🔄 Forçar Atualização de Comissões";
echo "</button>";
echo "</form>";

if (isset($_POST['forcar_atualizacao'])) {
    echo "<div style='background: #ffffcc; padding: 15px; margin: 10px 0; border: 2px solid #FFD700;'>";
    echo "<h3>Executando atualizarComissoes()...</h3>";
    ob_flush();
    flush();

    $resultado = atualizarComissoes($pdo, $promoter_id, $evento_id);

    echo "<p>Resultado: " . ($resultado ? "✅ SUCESSO" : "❌ FALHOU") . "</p>";
    echo "<p><a href='?promoter={$promoter_id}&evento={$evento_id}'>Atualizar página</a></p>";
    echo "</div>";
}
?>
