<?php
/**
 * Script de Migração: Adicionar Configurações de Email
 * Execute este arquivo uma vez para adicionar os campos necessários
 */

require_once 'config.php';

echo "====================================\n";
echo "MIGRAÇÃO: Configurações de Email\n";
echo "====================================\n\n";

try {
    // Verificar se as colunas já existem
    $stmt = $pdo->query("SHOW COLUMNS FROM configuracoes LIKE 'email_remetente'");
    $coluna_existe = $stmt->fetch();

    if ($coluna_existe) {
        echo "✅ As colunas de email já existem no banco de dados.\n\n";
    } else {
        echo "📝 Adicionando colunas de configuração de email...\n";

        // Adicionar colunas
        $pdo->exec("ALTER TABLE configuracoes
                    ADD COLUMN email_remetente VARCHAR(255) DEFAULT 'noreply@seudominio.com.br',
                    ADD COLUMN email_nome_remetente VARCHAR(255) DEFAULT 'Sistema Promotaal'");

        echo "✅ Colunas adicionadas com sucesso!\n\n";
    }

    // Atualizar registro padrão se necessário
    $stmt = $pdo->query("SELECT * FROM configuracoes WHERE id = 1");
    $config = $stmt->fetch();

    if ($config) {
        if (empty($config['email_remetente'])) {
            $pdo->exec("UPDATE configuracoes
                       SET email_remetente = 'noreply@seudominio.com.br',
                           email_nome_remetente = 'Sistema Promotaal'
                       WHERE id = 1");
            echo "✅ Valores padrão configurados!\n\n";
        } else {
            echo "✅ Configurações já estão definidas:\n";
            echo "   Email: {$config['email_remetente']}\n";
            echo "   Nome: {$config['email_nome_remetente']}\n\n";
        }
    }

    // Verificar resultado final
    $stmt = $pdo->query("SELECT email_remetente, email_nome_remetente FROM configuracoes WHERE id = 1");
    $resultado = $stmt->fetch();

    echo "====================================\n";
    echo "MIGRAÇÃO CONCLUÍDA COM SUCESSO!\n";
    echo "====================================\n\n";
    echo "Configurações atuais:\n";
    echo "  Email Remetente: {$resultado['email_remetente']}\n";
    echo "  Nome Remetente: {$resultado['email_nome_remetente']}\n\n";
    echo "📋 Próximo passo:\n";
    echo "   Acesse: Configurações > Configurações de Email\n";
    echo "   Altere o email remetente para o email do seu domínio.\n\n";

} catch (PDOException $e) {
    echo "❌ ERRO: " . $e->getMessage() . "\n\n";
    exit(1);
}
