-- Script para corrigir a coluna 'role' e permitir o valor 'produtor'
-- Execute este script no banco de dados se houver erro ao salvar usuário como produtor

-- Verificar o tipo atual da coluna role
-- Se for ENUM, precisamos alterar para incluir 'produtor'

-- Opção 1: Se a coluna for ENUM, alterar para incluir 'produtor'
ALTER TABLE `users`
MODIFY COLUMN `role` ENUM('admin', 'user', 'gerente', 'produtor') NOT NULL DEFAULT 'user';

-- Opção 2: Se preferir usar VARCHAR ao invés de ENUM (mais flexível)
-- ALTER TABLE `users`
-- MODIFY COLUMN `role` VARCHAR(20) NOT NULL DEFAULT 'user';

-- Verificar se a alteração funcionou
SELECT COLUMN_TYPE
FROM INFORMATION_SCHEMA.COLUMNS
WHERE TABLE_SCHEMA = 'luminainkcom_promoters_system'
  AND TABLE_NAME = 'users'
  AND COLUMN_NAME = 'role';
