<?php
// meus_saques.php - Histórico de saques do promoter (Padronizado)
header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache");

require_once 'config.php';
verificarLogin();

$user_id = $_SESSION['user_id'];

// Buscar dados do usuário para sidebar
$stmt = $pdo->prepare("SELECT * FROM users WHERE id = ?");
$stmt->execute([$user_id]);
$usuario = $stmt->fetch();

// Buscar histórico de saques
$stmt = $pdo->prepare("
    SELECT * FROM saques
    WHERE user_id = ?
    ORDER BY created_at DESC
");
$stmt->execute([$user_id]);
$saques = $stmt->fetchAll();

// Separar por status
$saques_pendentes = [];
$saques_aprovados = [];
$saques_concluidos = [];
$saques_cancelados = [];

foreach ($saques as $saque) {
    switch ($saque['status']) {
        case 'pendente':
            $saques_pendentes[] = $saque;
            break;
        case 'aprovado':
        case 'processando':
            $saques_aprovados[] = $saque;
            break;
        case 'concluido':
            $saques_concluidos[] = $saque;
            break;
        case 'cancelado':
            $saques_cancelados[] = $saque;
            break;
    }
}
?>
<!DOCTYPE html>
<html lang="pt-BR" data-theme="dark">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="Cache-Control" content="no-cache, no-store, must-revalidate">
    <meta http-equiv="Pragma" content="no-cache">
    <meta http-equiv="Expires" content="0">

    <title>Meus Saques - Sistema Promoters</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="assets/dashboard-style.css">
    <link rel="stylesheet" href="assets/css/sidebar.css">

    <style>
        .tabs {
            display: flex;
            gap: 10px;
            margin-bottom: 30px;
            border-bottom: 2px solid var(--border-color);
            overflow-x: auto;
            flex-wrap: wrap;
        }

        .tab {
            padding: 15px 25px;
            background: none;
            border: none;
            color: var(--text-secondary);
            font-size: 14px;
            font-weight: 600;
            cursor: pointer;
            border-bottom: 3px solid transparent;
            transition: all 0.3s;
            white-space: nowrap;
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .tab.active {
            color: var(--color-gold);
            border-bottom-color: var(--color-gold);
        }

        .tab:hover {
            color: var(--color-gold);
            background: var(--bg-card-hover);
        }

        .tab-content {
            display: none;
        }

        .tab-content.active {
            display: block;
        }

        .saque-card {
            background: var(--bg-card);
            border: 2px solid var(--border-color);
            border-radius: 15px;
            padding: 25px;
            margin-bottom: 20px;
            transition: all 0.3s ease;
        }

        .saque-card:hover {
            border-color: var(--border-gold);
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(255, 215, 0, 0.2);
        }

        .saque-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
            padding-bottom: 20px;
            border-bottom: 2px solid var(--border-color);
        }

        .saque-badges {
            display: flex;
            gap: 10px;
            flex-wrap: wrap;
        }

        .saque-valor {
            font-size: 32px;
            font-weight: 700;
            color: var(--color-gold);
        }

        .saque-info {
            display: grid;
            gap: 12px;
        }

        .info-row {
            display: flex;
            justify-content: space-between;
            font-size: 15px;
            padding: 10px 0;
        }

        .info-label {
            color: var(--text-secondary);
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .info-value {
            font-weight: 600;
            color: var(--text-primary);
        }

        .timeline {
            position: relative;
            padding-left: 35px;
            margin-top: 20px;
        }

        .timeline::before {
            content: '';
            position: absolute;
            left: 12px;
            top: 0;
            bottom: 0;
            width: 3px;
            background: var(--border-color);
            border-radius: 3px;
        }

        .timeline-item {
            position: relative;
            padding-bottom: 20px;
        }

        .timeline-item::before {
            content: '';
            position: absolute;
            left: -29px;
            top: 5px;
            width: 12px;
            height: 12px;
            border-radius: 50%;
            background: var(--color-gold);
            border: 3px solid var(--bg-card);
            box-shadow: 0 0 0 2px var(--color-gold);
        }

        .timeline-title {
            font-weight: 600;
            margin-bottom: 5px;
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .timeline-date {
            font-size: 13px;
            color: var(--text-secondary);
        }

        .status-box {
            margin-top: 20px;
            padding: 18px 20px;
            border-radius: 12px;
            font-size: 14px;
            line-height: 1.6;
            display: flex;
            align-items: flex-start;
            gap: 12px;
        }

        .status-box.warning {
            background: rgba(255, 165, 0, 0.1);
            border: 2px solid var(--color-gold-dark);
            color: var(--color-gold-dark);
        }

        .status-box.info {
            background: rgba(23, 162, 184, 0.1);
            border: 2px solid #17a2b8;
            color: #17a2b8;
        }

        .status-box.success {
            background: rgba(0, 200, 81, 0.1);
            border: 2px solid var(--success-color);
            color: var(--success-color);
        }

        .status-box.danger {
            background: rgba(220, 53, 69, 0.1);
            border: 2px solid var(--danger-color);
            color: var(--danger-color);
        }

        .status-box i {
            font-size: 20px;
            margin-top: 2px;
        }

        @media (max-width: 768px) {
            .saque-header {
                flex-direction: column;
                gap: 15px;
                align-items: flex-start;
            }

            .saque-valor {
                font-size: 28px;
            }

            .tabs {
                gap: 5px;
            }

            .tab {
                padding: 12px 15px;
                font-size: 12px;
            }

            .info-row {
                flex-direction: column;
                gap: 5px;
            }
        }
    </style>
</head>
<body>

    <?php include 'assets/sidebar.php'; ?>

    <div class="container">

        <div class="welcome-section">
            <h1 class="welcome-title">
                <i class="fas fa-file-invoice-dollar"></i>
                Histórico de Saques
            </h1>
            <p class="welcome-subtitle">
                Acompanhe todas as suas solicitações de saque
            </p>
        </div>

        <!-- Tabs -->
        <div class="tabs">
            <button class="tab active" onclick="switchTab('pendentes')">
                <i class="fas fa-clock"></i>
                Aguardando Aprovação (<?= count($saques_pendentes) ?>)
            </button>
            <button class="tab" onclick="switchTab('aprovados')">
                <i class="fas fa-check-circle"></i>
                Aprovados (<?= count($saques_aprovados) ?>)
            </button>
            <button class="tab" onclick="switchTab('concluidos')">
                <i class="fas fa-money-bill-wave"></i>
                Pagos (<?= count($saques_concluidos) ?>)
            </button>
            <button class="tab" onclick="switchTab('cancelados')">
                <i class="fas fa-times-circle"></i>
                Cancelados (<?= count($saques_cancelados) ?>)
            </button>
        </div>

        <!-- PENDENTES -->
        <div id="tab-pendentes" class="tab-content active">
            <?php if (count($saques_pendentes) > 0): ?>
                <?php foreach ($saques_pendentes as $saque): ?>
                    <div class="saque-card">
                        <div class="saque-header">
                            <div class="saque-badges">
                                <span class="badge badge-warning">
                                    <i class="fas fa-clock"></i> Aguardando Aprovação
                                </span>
                                <?php if ($saque['tipo'] === 'pix'): ?>
                                    <span class="badge badge-info">
                                        <i class="fas fa-pix"></i> PIX
                                    </span>
                                <?php else: ?>
                                    <span class="badge badge-success">
                                        <i class="fas fa-glass-cheers"></i> Crédito
                                    </span>
                                <?php endif; ?>
                            </div>
                            <div class="saque-valor"><?= formatarMoeda($saque['valor']) ?></div>
                        </div>

                        <div class="saque-info">
                            <div class="info-row">
                                <span class="info-label">
                                    <i class="fas fa-calendar-alt"></i> Solicitado em:
                                </span>
                                <span class="info-value"><?= formatarDataHora($saque['created_at']) ?></span>
                            </div>

                            <?php if ($saque['tipo'] === 'pix'): ?>
                                <div class="info-row">
                                    <span class="info-label">
                                        <i class="fas fa-key"></i> Chave PIX:
                                    </span>
                                    <span class="info-value"><?= htmlspecialchars($saque['pix']) ?></span>
                                </div>
                                <div class="info-row">
                                    <span class="info-label">
                                        <i class="fas fa-id-card"></i> CPF:
                                    </span>
                                    <span class="info-value"><?= htmlspecialchars($saque['cpf']) ?></span>
                                </div>
                            <?php endif; ?>
                        </div>

                        <div class="status-box warning">
                            <i class="fas fa-clock"></i>
                            <div>Seu pedido está em análise. Aguarde a aprovação do administrador.</div>
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php else: ?>
                <div class="empty-state">
                    <div class="empty-state-icon">
                        <i class="fas fa-inbox"></i>
                    </div>
                    <h3>Nenhuma solicitação pendente</h3>
                    <p>Todas as suas solicitações foram processadas</p>
                </div>
            <?php endif; ?>
        </div>

        <!-- APROVADOS -->
        <div id="tab-aprovados" class="tab-content">
            <?php if (count($saques_aprovados) > 0): ?>
                <?php foreach ($saques_aprovados as $saque): ?>
                    <div class="saque-card">
                        <div class="saque-header">
                            <div class="saque-badges">
                                <span class="badge badge-success">
                                    <i class="fas fa-check-circle"></i> Aprovado
                                </span>
                                <?php if ($saque['tipo'] === 'pix'): ?>
                                    <span class="badge badge-info">
                                        <i class="fas fa-pix"></i> PIX
                                    </span>
                                <?php else: ?>
                                    <span class="badge badge-success">
                                        <i class="fas fa-glass-cheers"></i> Crédito
                                    </span>
                                <?php endif; ?>
                            </div>
                            <div class="saque-valor"><?= formatarMoeda($saque['valor']) ?></div>
                        </div>

                        <div class="saque-info">
                            <div class="info-row">
                                <span class="info-label">
                                    <i class="fas fa-calendar-alt"></i> Solicitado em:
                                </span>
                                <span class="info-value"><?= formatarDataHora($saque['created_at']) ?></span>
                            </div>
                        </div>

                        <div class="status-box info">
                            <i class="fas fa-check-circle"></i>
                            <div>
                                <?php if ($saque['tipo'] === 'pix'): ?>
                                    Aprovado! O pagamento será processado em até 3-5 dias úteis.
                                <?php else: ?>
                                    Aprovado! Dirija-se à bilheteria do evento para retirar seu crédito.
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php else: ?>
                <div class="empty-state">
                    <div class="empty-state-icon">
                        <i class="fas fa-list-alt"></i>
                    </div>
                    <h3>Nenhum saque aprovado</h3>
                    <p>Solicitações aprovadas aparecerão aqui</p>
                </div>
            <?php endif; ?>
        </div>

        <!-- CONCLUÍDOS -->
        <div id="tab-concluidos" class="tab-content">
            <?php if (count($saques_concluidos) > 0): ?>
                <?php foreach ($saques_concluidos as $saque): ?>
                    <div class="saque-card">
                        <div class="saque-header">
                            <div class="saque-badges">
                                <span class="badge badge-success">
                                    <i class="fas fa-check-double"></i> PAGO
                                </span>
                                <?php if ($saque['tipo'] === 'pix'): ?>
                                    <span class="badge badge-info">
                                        <i class="fas fa-pix"></i> PIX
                                    </span>
                                <?php else: ?>
                                    <span class="badge badge-success">
                                        <i class="fas fa-glass-cheers"></i> Crédito
                                    </span>
                                <?php endif; ?>
                            </div>
                            <div class="saque-valor"><?= formatarMoeda($saque['valor']) ?></div>
                        </div>

                        <div class="timeline">
                            <div class="timeline-item">
                                <div class="timeline-title">
                                    <i class="fas fa-paper-plane"></i> Solicitado
                                </div>
                                <div class="timeline-date"><?= formatarDataHora($saque['created_at']) ?></div>
                            </div>
                            <div class="timeline-item">
                                <div class="timeline-title">
                                    <i class="fas fa-check-circle"></i> Pago
                                </div>
                                <div class="timeline-date">
                                    <?= isset($saque['processado_at']) ? formatarDataHora($saque['processado_at']) : 'Processado' ?>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php else: ?>
                <div class="empty-state">
                    <div class="empty-state-icon">
                        <i class="fas fa-wallet"></i>
                    </div>
                    <h3>Nenhum pagamento recebido ainda</h3>
                    <p>Seus pagamentos concluídos aparecerão aqui</p>
                </div>
            <?php endif; ?>
        </div>

        <!-- CANCELADOS -->
        <div id="tab-cancelados" class="tab-content">
            <?php if (count($saques_cancelados) > 0): ?>
                <?php foreach ($saques_cancelados as $saque): ?>
                    <div class="saque-card">
                        <div class="saque-header">
                            <div class="saque-badges">
                                <span class="badge badge-danger">
                                    <i class="fas fa-times-circle"></i> Cancelado
                                </span>
                                <?php if ($saque['tipo'] === 'pix'): ?>
                                    <span class="badge badge-info">
                                        <i class="fas fa-pix"></i> PIX
                                    </span>
                                <?php else: ?>
                                    <span class="badge badge-success">
                                        <i class="fas fa-glass-cheers"></i> Crédito
                                    </span>
                                <?php endif; ?>
                            </div>
                            <div class="saque-valor"><?= formatarMoeda($saque['valor']) ?></div>
                        </div>

                        <div class="saque-info">
                            <div class="info-row">
                                <span class="info-label">
                                    <i class="fas fa-calendar-alt"></i> Solicitado em:
                                </span>
                                <span class="info-value"><?= formatarDataHora($saque['created_at']) ?></span>
                            </div>
                        </div>

                        <div class="status-box danger">
                            <i class="fas fa-exclamation-triangle"></i>
                            <div>Este saque foi cancelado. O valor foi devolvido ao seu saldo disponível.</div>
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php else: ?>
                <div class="empty-state">
                    <div class="empty-state-icon">
                        <i class="fas fa-check-circle"></i>
                    </div>
                    <h3>Nenhum saque cancelado</h3>
                    <p>Você não tem saques cancelados</p>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <script>
        function switchTab(tabName) {
            document.querySelectorAll('.tab').forEach(t => t.classList.remove('active'));
            document.querySelectorAll('.tab-content').forEach(c => c.classList.remove('active'));

            event.target.classList.add('active');
            document.getElementById('tab-' + tabName).classList.add('active');
        }
    </script>
    </div><!-- /.main-content -->
    <script src="assets/js/sidebar.js"></script>
</body>
</html>
