-- ============================================
-- FIX: Correção da tabela conversas
-- Data: 2025-01-17
-- Problema: UNIQUE KEY não pode usar funções LEAST/GREATEST
-- Solução: Usar colunas geradas (generated columns)
-- ============================================

-- Remover tabela se já existe
DROP TABLE IF EXISTS conversas;

-- Recriar com colunas geradas
CREATE TABLE conversas (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user1_id INT NOT NULL,
    user2_id INT NOT NULL,

    -- Colunas geradas para garantir unicidade independente da ordem
    -- STORED = armazenado fisicamente (melhor para índices)
    user_menor INT AS (LEAST(user1_id, user2_id)) STORED,
    user_maior INT AS (GREATEST(user1_id, user2_id)) STORED,

    ultima_mensagem_id INT NULL,
    ultima_atividade TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,

    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,

    FOREIGN KEY (user1_id) REFERENCES users(id) ON DELETE CASCADE,
    FOREIGN KEY (user2_id) REFERENCES users(id) ON DELETE CASCADE,

    -- Agora podemos criar UNIQUE KEY nas colunas geradas
    UNIQUE KEY unique_conversa (user_menor, user_maior),

    INDEX idx_users (user1_id, user2_id),
    INDEX idx_atividade (ultima_atividade)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Verificar criação
SELECT 'Tabela conversas criada com sucesso!' as status;
