-- migration_relatorios_salvos.sql
-- Sistema de histórico de relatórios gerados
-- Permite salvar e fazer download posterior dos relatórios

CREATE TABLE IF NOT EXISTS relatorios_salvos (
    id INT AUTO_INCREMENT PRIMARY KEY,
    admin_id INT NOT NULL,
    tipo VARCHAR(50) NOT NULL COMMENT 'Tipo do relatório: convidados_categoria, evento_completo, etc',
    categoria VARCHAR(100) DEFAULT NULL COMMENT 'Categoria do evento filtrada',
    data_inicio DATE DEFAULT NULL,
    data_fim DATE DEFAULT NULL,
    evento_id INT DEFAULT NULL,
    arquivo_nome VARCHAR(255) NOT NULL COMMENT 'Nome do arquivo gerado',
    arquivo_path VARCHAR(500) NOT NULL COMMENT 'Caminho do arquivo no servidor',
    total_registros INT DEFAULT 0 COMMENT 'Total de registros no relatório',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    INDEX idx_admin (admin_id),
    INDEX idx_tipo (tipo),
    INDEX idx_created (created_at),
    FOREIGN KEY (admin_id) REFERENCES users(id) ON DELETE CASCADE,
    FOREIGN KEY (evento_id) REFERENCES eventos(id) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci
COMMENT='Histórico de relatórios gerados para download posterior';

-- Criar diretório para armazenar relatórios (fazer manualmente via FTP/SSH)
-- mkdir -p relatorios_salvos
-- chmod 755 relatorios_salvos
