<?php
// produtor_listas.php - Minhas listas para produtores
header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache");

require_once 'config.php';
verificarLogin();

// Verificar se é produtor
if ($_SESSION['role'] !== 'produtor') {
    header('Location: dashboard.php');
    exit;
}

$user_id = $_SESSION['user_id'];
$sucesso = '';
$erro = '';

// Deletar convidado
if (isset($_GET['deletar'])) {
    $convidado_id = intval($_GET['deletar']);
    $stmt = $pdo->prepare("DELETE FROM convidados WHERE id = ? AND promoter_id = ?");
    if ($stmt->execute([$convidado_id, $user_id])) {
        $sucesso = 'Convidado removido!';
    }
}

// Buscar todos os eventos do produtor
$stmt = $pdo->prepare("
    SELECT e.*, pe.link_exclusivo,
    (SELECT COUNT(*) FROM convidados c WHERE c.promoter_id = ? AND c.evento_id = e.id) as total_convidados,
    (SELECT COUNT(*) FROM convidados c WHERE c.promoter_id = ? AND c.evento_id = e.id AND c.checkin = 1) as total_checkins,
    (SELECT COUNT(*) FROM convidados c WHERE c.promoter_id = ? AND c.evento_id = e.id AND c.checkin = 0) as total_pendentes
    FROM eventos e
    INNER JOIN produtor_eventos pe ON e.id = pe.evento_id
    WHERE pe.user_id = ?
    ORDER BY e.data DESC
");
$stmt->execute([$user_id, $user_id, $user_id, $user_id]);
$meus_eventos = $stmt->fetchAll();

// Se um evento foi selecionado
$evento_selecionado = null;
$convidados = [];
$convidados_checkin = [];
$convidados_pendentes = [];

if (isset($_GET['evento_id'])) {
    $evento_id = intval($_GET['evento_id']);

    $stmt = $pdo->prepare("
        SELECT e.*, pe.link_exclusivo
        FROM eventos e
        INNER JOIN produtor_eventos pe ON e.id = pe.evento_id
        WHERE e.id = ? AND pe.user_id = ?
    ");
    $stmt->execute([$evento_id, $user_id]);
    $evento_selecionado = $stmt->fetch();

    if ($evento_selecionado) {
        $stmt = $pdo->prepare("
            SELECT * FROM convidados
            WHERE promoter_id = ? AND evento_id = ?
            ORDER BY created_at DESC
        ");
        $stmt->execute([$user_id, $evento_id]);
        $convidados = $stmt->fetchAll();

        foreach ($convidados as $conv) {
            if ($conv['checkin']) {
                $convidados_checkin[] = $conv;
            } else {
                $convidados_pendentes[] = $conv;
            }
        }
    }
// Buscar dados do usuário para sidebar
$stmt = $pdo->prepare("SELECT * FROM users WHERE id = ?");
$stmt->execute([$user_id]);
$usuario = $stmt->fetch();
}
?>
<!DOCTYPE html>
<html lang="pt-BR" data-theme="dark">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Minhas Listas - Produtor</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="assets/dashboard-style.css">
    <link rel="stylesheet" href="assets/css/sidebar.css">
    <style>

        body {
            font-family: 'Inter', -apple-system, sans-serif;
            background: var(--bg-secondary);
            color: var(--text-primary);
            line-height: 1.6;
        }

        .navbar {
            background: var(--bg-primary);
            border-bottom: 2px solid var(--border-color);
            padding: 20px;
            position: sticky;
            top: 0;
            z-index: 1000;
        }

        .navbar-container {
            max-width: 1400px;
            margin: 0 auto;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .navbar-brand {
            font-size: 28px;
            font-weight: 700;
            color: var(--color-gold);
            display: flex;
            align-items: center;
            gap: 12px;
        }

        .navbar-links {
            display: flex;
            gap: 10px;
        }

        .nav-link {
            color: var(--text-primary);
            text-decoration: none;
            padding: 10px 20px;
            border-radius: 10px;
            transition: all 0.3s;
            font-size: 14px;
            border: 2px solid var(--border-color);
        }

        .nav-link:hover {
            border-color: var(--color-gold);
            color: var(--color-gold);
        }

        .container {
            max-width: 1400px;
            margin: 0 auto;
            padding: 30px 20px;
        }

        .alert {
            padding: 15px 20px;
            border-radius: 10px;
            margin-bottom: 20px;
        }

        .alert-success {
            background: rgba(0, 200, 81, 0.15);
            border: 2px solid #00C851;
            color: #00C851;
        }

        .eventos-selector {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(250px, 1fr));
            gap: 15px;
            margin-bottom: 30px;
        }

        .evento-card {
            background: var(--bg-card);
            border: 2px solid var(--border-color);
            border-radius: 12px;
            padding: 20px;
            cursor: pointer;
            transition: all 0.3s;
            text-decoration: none;
            color: var(--text-primary);
        }

        .evento-card:hover {
            transform: translateY(-3px);
            border-color: var(--color-gold);
        }

        .evento-card.active {
            border-color: var(--color-gold);
            background: linear-gradient(135deg, rgba(255, 215, 0, 0.1), rgba(255, 165, 0, 0.05));
        }

        .evento-nome {
            font-weight: 700;
            margin-bottom: 10px;
            color: var(--color-gold);
        }

        .evento-stats {
            display: flex;
            gap: 15px;
            font-size: 13px;
            color: var(--text-secondary);
        }

        .evento-stats span {
            display: flex;
            align-items: center;
            gap: 5px;
        }

        .convidados-section {
            background: var(--bg-card);
            border: 2px solid var(--border-color);
            border-radius: 15px;
            padding: 30px;
            margin-bottom: 30px;
        }

        .section-title {
            font-size: 24px;
            font-weight: 700;
            margin-bottom: 20px;
            color: var(--color-gold);
            display: flex;
            align-items: center;
            gap: 10px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
        }

        th {
            background: var(--bg-secondary);
            padding: 15px;
            text-align: left;
            font-weight: 600;
            border-bottom: 2px solid var(--border-color);
            color: var(--color-gold);
        }

        td {
            padding: 15px;
            border-bottom: 1px solid var(--border-color);
        }

        tr:hover {
            background: rgba(255, 215, 0, 0.05);
        }

        .btn {
            padding: 8px 15px;
            border: none;
            border-radius: 8px;
            font-size: 13px;
            cursor: pointer;
            transition: all 0.3s;
            text-decoration: none;
            display: inline-block;
        }

        .btn-danger {
            background: #dc3545;
            color: white;
        }

        .btn-danger:hover {
            background: #c82333;
        }

        .empty-state {
            text-align: center;
            padding: 60px 20px;
            color: var(--text-secondary);
        }

        .empty-state i {
            font-size: 60px;
            margin-bottom: 15px;
            opacity: 0.3;
        }

        .badge {
            padding: 4px 10px;
            border-radius: 15px;
            font-size: 11px;
            font-weight: 600;
        }

        .badge-success {
            background: #00C851;
            color: white;
        }

        .badge-warning {
            background: #FFA500;
            color: white;
        }

        @media (max-width: 768px) {
            .navbar-container {
                flex-direction: column;
                gap: 15px;
            }

            table {
                font-size: 12px;
            }

            th, td {
                padding: 10px 5px;
            }
        }
    </style>
</head>
<body>

    <nav class="navbar">
        <div class="navbar-container">
            <div class="navbar-brand">
                <i class="fas fa-list"></i>
                Minhas Listas
            </div>

            <div class="navbar-links">
                <a href="dashboard.php" class="nav-link">
                    <i class="fas fa-home"></i> Dashboard
                </a>
                <a href="produtor_eventos.php" class="nav-link">
                    <i class="fas fa-calendar-alt"></i> Eventos
                </a>
                <a href="produtor_listas.php" class="nav-link" style="border-color: var(--color-gold);">
                    <i class="fas fa-list"></i> Listas
                </a>
                <a href="produtor_financeiro.php" class="nav-link">
                    <i class="fas fa-wallet"></i> Financeiro
                </a>
                <a href="logout.php" class="nav-link" style="border-color: #dc3545; color: #dc3545;">
                    <i class="fas fa-sign-out-alt"></i> Sair
                </a>
            </div>
        </div>
    </nav>

    <div class="container">

        <?php if ($sucesso): ?>
            <div class="alert alert-success"><?= htmlspecialchars($sucesso) ?></div>
        <?php endif; ?>

        <?php if (count($meus_eventos) > 0): ?>
            <h2 class="section-title">
                <i class="fas fa-calendar-alt"></i>
                Selecione um Evento
            </h2>

            <div class="eventos-selector">
                <?php foreach ($meus_eventos as $evt): ?>
                    <a href="?evento_id=<?= $evt['id'] ?>"
                       class="evento-card <?= (isset($_GET['evento_id']) && $_GET['evento_id'] == $evt['id']) ? 'active' : '' ?>">
                        <div class="evento-nome"><?= htmlspecialchars($evt['nome']) ?></div>
                        <div class="evento-stats">
                            <span><i class="fas fa-users"></i> <?= $evt['total_convidados'] ?></span>
                            <span><i class="fas fa-check-circle"></i> <?= $evt['total_checkins'] ?></span>
                            <span><i class="fas fa-clock"></i> <?= $evt['total_pendentes'] ?></span>
                        </div>
                    </a>
                <?php endforeach; ?>
            </div>

            <?php if ($evento_selecionado): ?>

                <!-- CONVIDADOS COM CHECK-IN -->
                <?php if (count($convidados_checkin) > 0): ?>
                    <div class="convidados-section">
                        <h3 class="section-title">
                            <i class="fas fa-check-circle" style="color: #00C851;"></i>
                            Confirmados (<?= count($convidados_checkin) ?>)
                        </h3>

                        <table>
                            <thead>
                                <tr>
                                    <th>Nome</th>
                                    <th>WhatsApp</th>
                                    <th>Email</th>
                                    <th>Data Cadastro</th>
                                    <th>Ações</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($convidados_checkin as $conv): ?>
                                    <tr>
                                        <td>
                                            <strong><?= htmlspecialchars($conv['nome']) ?></strong>
                                            <br><span class="badge badge-success">✓ Presente</span>
                                        </td>
                                        <td><?= htmlspecialchars($conv['whatsapp']) ?></td>
                                        <td><?= htmlspecialchars($conv['email']) ?></td>
                                        <td><?= date('d/m/Y H:i', strtotime($conv['created_at'])) ?></td>
                                        <td>
                                            <a href="?evento_id=<?= $evento_selecionado['id'] ?>&deletar=<?= $conv['id'] ?>"
                                               class="btn btn-danger"
                                               onclick="return confirm('Deletar este convidado?')">
                                                <i class="fas fa-trash"></i>
                                            </a>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                <?php endif; ?>

                <!-- CONVIDADOS PENDENTES -->
                <?php if (count($convidados_pendentes) > 0): ?>
                    <div class="convidados-section">
                        <h3 class="section-title">
                            <i class="fas fa-clock" style="color: #FFA500;"></i>
                            Pendentes (<?= count($convidados_pendentes) ?>)
                        </h3>

                        <table>
                            <thead>
                                <tr>
                                    <th>Nome</th>
                                    <th>WhatsApp</th>
                                    <th>Email</th>
                                    <th>Data Cadastro</th>
                                    <th>Ações</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($convidados_pendentes as $conv): ?>
                                    <tr>
                                        <td>
                                            <strong><?= htmlspecialchars($conv['nome']) ?></strong>
                                            <br><span class="badge badge-warning">⏳ Aguardando</span>
                                        </td>
                                        <td><?= htmlspecialchars($conv['whatsapp']) ?></td>
                                        <td><?= htmlspecialchars($conv['email']) ?></td>
                                        <td><?= date('d/m/Y H:i', strtotime($conv['created_at'])) ?></td>
                                        <td>
                                            <a href="?evento_id=<?= $evento_selecionado['id'] ?>&deletar=<?= $conv['id'] ?>"
                                               class="btn btn-danger"
                                               onclick="return confirm('Deletar este convidado?')">
                                                <i class="fas fa-trash"></i>
                                            </a>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                <?php endif; ?>

                <?php if (count($convidados) === 0): ?>
                    <div class="empty-state">
                        <i class="fas fa-users-slash"></i>
                        <h3>Nenhum convidado ainda</h3>
                        <p>Compartilhe seu link para começar a receber convidados!</p>
                    </div>
                <?php endif; ?>

            <?php else: ?>
                <div class="empty-state">
                    <i class="fas fa-hand-point-up"></i>
                    <h3>Selecione um evento acima</h3>
                    <p>Escolha um evento para ver sua lista de convidados</p>
                </div>
            <?php endif; ?>

        <?php else: ?>
            <div class="empty-state">
                <i class="fas fa-calendar-times"></i>
                <h3>Nenhum evento associado</h3>
                <p>Entre em contato com o administrador para ser associado a eventos.</p>
            </div>
        <?php endif; ?>

    </div>

    </div><!-- /.main-content -->
    <script src="assets/js/sidebar.js"></script>
</body>
</html>
