-- Script SQL para adicionar funcionalidade de Produtor
-- Execute este script no banco de dados

-- 1. Criar tabela para associar Produtores a Eventos
CREATE TABLE IF NOT EXISTS `produtor_eventos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `evento_id` int(11) NOT NULL,
  `link_exclusivo` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_link` (`link_exclusivo`),
  UNIQUE KEY `unique_user_evento` (`user_id`, `evento_id`),
  KEY `user_id` (`user_id`),
  KEY `evento_id` (`evento_id`),
  FOREIGN KEY (`user_id`) REFERENCES `users`(`id`) ON DELETE CASCADE,
  FOREIGN KEY (`evento_id`) REFERENCES `eventos`(`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- 2. Alterar tabela users para aceitar role 'produtor'
-- IMPORTANTE: Se a coluna 'role' for ENUM, precisamos adicionar 'produtor' aos valores aceitos
ALTER TABLE `users`
MODIFY COLUMN `role` ENUM('admin', 'user', 'gerente', 'produtor') NOT NULL DEFAULT 'user';

-- Se preferir usar VARCHAR ao invés de ENUM (mais flexível para futuros roles):
-- ALTER TABLE `users`
-- MODIFY COLUMN `role` VARCHAR(20) NOT NULL DEFAULT 'user';

-- 3. Índices para melhorar performance de consultas
CREATE INDEX idx_produtor_eventos_user ON produtor_eventos(user_id);
CREATE INDEX idx_produtor_eventos_evento ON produtor_eventos(evento_id);

-- Script concluído!
-- Agora você pode criar usuários com role = 'produtor' e associá-los a eventos
