<?php
// test_api.php - Testar APIs
require_once 'config.php';
verificarLogin();

header('Content-Type: text/html; charset=utf-8');

$user_id = $_SESSION['user_id'];
echo "<h1>Teste das APIs de Notificações</h1>";
echo "<p><strong>User ID:</strong> $user_id</p>";
echo "<hr>";

// Testar API de mensagens
echo "<h2>1. API de Mensagens (GET)</h2>";
echo "<p><strong>URL:</strong> api/mensagens_api.php?action=contar</p>";

// Simular a requisição da API
$_GET['action'] = 'contar';
ob_start();
include 'api/mensagens_api.php';
$response_msg = ob_get_clean();

echo "<p><strong>Resposta:</strong></p>";
echo "<pre>" . htmlspecialchars($response_msg) . "</pre>";
echo "<hr>";

// Testar API de notificações
echo "<h2>2. API de Notificações (GET)</h2>";
echo "<p><strong>URL:</strong> api/notificacoes_api.php?action=contar</p>";

// Simular a requisição da API
$_GET['action'] = 'contar';
ob_start();
include 'api/notificacoes_api.php';
$response_notif = ob_get_clean();

echo "<p><strong>Resposta:</strong></p>";
echo "<pre>" . htmlspecialchars($response_notif) . "</pre>";
echo "<hr>";

// Teste direto no banco
echo "<h2>3. Teste Direto no Banco</h2>";

echo "<h3>Contadores do usuário:</h3>";
$stmt = $pdo->prepare("SELECT mensagens_nao_lidas, notificacoes_nao_lidas FROM users WHERE id = ?");
$stmt->execute([$user_id]);
$contadores = $stmt->fetch();
echo "<pre>";
print_r($contadores);
echo "</pre>";

echo "<h3>Mensagens não lidas:</h3>";
$stmt = $pdo->prepare("
    SELECT COUNT(*) as total
    FROM mensagens_destinatarios
    WHERE destinatario_id = ? AND lida = 0
");
$stmt->execute([$user_id]);
$msg_count = $stmt->fetch();
echo "<p>Total: {$msg_count['total']}</p>";

echo "<h3>Notificações não lidas:</h3>";
$stmt = $pdo->prepare("
    SELECT COUNT(*) as total
    FROM notificacoes
    WHERE user_id = ? AND lida = 0
");
$stmt->execute([$user_id]);
$notif_count = $stmt->fetch();
echo "<p>Total: {$notif_count['total']}</p>";

echo "<hr>";
echo "<p><a href='debug_notificacoes.php'>Ver Debug Completo</a> | <a href='dashboard.php'>Dashboard</a></p>";
?>
