<?php
/**
 * Script de Diagnóstico - Envio de Email de Aniversário
 * Execute este arquivo para testar o envio de email de aniversário
 */

require_once 'config.php';

echo "====================================\n";
echo "DIAGNÓSTICO: Email de Aniversário\n";
echo "====================================\n\n";

// 1. Verificar se as constantes estão definidas
echo "1. Verificando constantes de email...\n";
if (defined('EMAIL_REMETENTE')) {
    echo "   ✅ EMAIL_REMETENTE: " . EMAIL_REMETENTE . "\n";
} else {
    echo "   ❌ EMAIL_REMETENTE não está definida!\n";
}

if (defined('EMAIL_NOME_REMETENTE')) {
    echo "   ✅ EMAIL_NOME_REMETENTE: " . EMAIL_NOME_REMETENTE . "\n";
} else {
    echo "   ❌ EMAIL_NOME_REMETENTE não está definida!\n";
}

echo "\n";

// 2. Verificar se as colunas existem no banco
echo "2. Verificando banco de dados...\n";
try {
    $stmt = $pdo->query("SHOW COLUMNS FROM configuracoes LIKE 'email_remetente'");
    $coluna = $stmt->fetch();
    if ($coluna) {
        echo "   ✅ Coluna 'email_remetente' existe\n";
    } else {
        echo "   ❌ Coluna 'email_remetente' NÃO existe - EXECUTE A MIGRAÇÃO!\n";
        echo "   Execute: php executar_migracao_email.php\n";
    }

    $stmt = $pdo->query("SELECT email_remetente, email_nome_remetente FROM configuracoes WHERE id = 1");
    $config = $stmt->fetch();
    if ($config) {
        echo "   ✅ Configurações no banco:\n";
        echo "      Email: " . $config['email_remetente'] . "\n";
        echo "      Nome: " . $config['email_nome_remetente'] . "\n";
    }
} catch (PDOException $e) {
    echo "   ❌ Erro ao acessar banco: " . $e->getMessage() . "\n";
}

echo "\n";

// 3. Verificar função mail()
echo "3. Verificando função mail()...\n";
if (function_exists('mail')) {
    echo "   ✅ Função mail() está disponível\n";
} else {
    echo "   ❌ Função mail() NÃO está disponível!\n";
}

echo "\n";

// 4. Testar envio de email
echo "4. Digite um email para teste (ou ENTER para pular): ";
$email_teste = trim(fgets(STDIN));

if (!empty($email_teste) && filter_var($email_teste, FILTER_VALIDATE_EMAIL)) {
    echo "\n   Enviando email de teste para: $email_teste\n";

    $assunto = "Teste de Email de Aniversário - " . date('d/m/Y H:i:s');
    $mensagem = "Feliz Aniversário!\n\nEste é um email de teste do sistema.";

    // Preparar headers
    $headers = "MIME-Version: 1.0\r\n";
    $headers .= "Content-Type: text/html; charset=UTF-8\r\n";
    $headers .= "From: " . EMAIL_NOME_REMETENTE . " <" . EMAIL_REMETENTE . ">\r\n";

    // HTML do email
    $corpo_html = nl2br(htmlspecialchars($mensagem));
    $html_email = "
    <!DOCTYPE html>
    <html>
    <head>
        <meta charset='UTF-8'>
        <style>
            body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }
            .container { max-width: 600px; margin: 0 auto; padding: 20px; }
            .header { background: linear-gradient(135deg, #FFD700 0%, #FFA500 100%); color: white; padding: 30px; text-align: center; border-radius: 10px 10px 0 0; }
            .content { background: #fff; padding: 30px; border: 1px solid #ddd; }
            .footer { background: #f5f5f5; padding: 20px; text-align: center; font-size: 12px; color: #666; border-radius: 0 0 10px 10px; }
            .emoji { font-size: 48px; }
        </style>
    </head>
    <body>
        <div class='container'>
            <div class='header'>
                <div class='emoji'>🎉</div>
                <h1 style='margin: 10px 0 0 0;'>$assunto</h1>
            </div>
            <div class='content'>
                $corpo_html
            </div>
            <div class='footer'>
                Enviado por " . EMAIL_NOME_REMETENTE . "
            </div>
        </div>
    </body>
    </html>";

    if (mail($email_teste, $assunto, $html_email, $headers)) {
        echo "   ✅ Email enviado com sucesso!\n";
        echo "   Verifique sua caixa de entrada (e spam)\n";
    } else {
        echo "   ❌ Falha ao enviar email\n";
        echo "   Verifique os logs do servidor\n";
    }
} else {
    echo "   ⏭️  Teste de envio pulado\n";
}

echo "\n";

// 5. Verificar configurações de aniversário
echo "5. Verificando configurações de aniversários...\n";
try {
    $stmt = $pdo->query("SELECT * FROM configuracoes_aniversarios LIMIT 1");
    $config_aniv = $stmt->fetch();

    if ($config_aniv) {
        echo "   ✅ Configurações encontradas:\n";
        echo "      Assunto Padrão: " . substr($config_aniv['mensagem_padrao_assunto'], 0, 50) . "...\n";
        echo "      Envio Automático: " . ($config_aniv['envio_automatico_ativo'] ? 'Ativo' : 'Inativo') . "\n";
    } else {
        echo "   ❌ Configurações de aniversário não encontradas!\n";
    }
} catch (PDOException $e) {
    echo "   ❌ Erro: " . $e->getMessage() . "\n";
}

echo "\n====================================\n";
echo "DIAGNÓSTICO CONCLUÍDO\n";
echo "====================================\n";
