<?php
// teste_debug_saques.php - Debug específico de Saques e Comissões
require_once 'config.php';
require_once 'includes/functions_notificacoes.php';

echo "<h1>Debug de Saques e Notificações</h1>";
echo "<style>
    body { font-family: Arial; background: #0a0a0a; color: #fff; padding: 20px; }
    table { border-collapse: collapse; width: 100%; margin: 20px 0; background: #1a1a1a; }
    th, td { border: 1px solid #FFD700; padding: 10px; text-align: left; }
    th { background: #2a2a2a; color: #FFD700; }
    h2 { color: #FFD700; border-bottom: 2px solid #FFD700; padding-bottom: 10px; margin-top: 30px; }
    .success { color: #00C851; }
    .error { color: #dc3545; }
    .warning { color: #FFA500; }
    pre { background: #1a1a1a; padding: 10px; border: 1px solid #FFD700; overflow-x: auto; }
</style>";

// 1. VERIFICAR ADMINS
echo "<h2>1. Admins no Sistema</h2>";
$stmt = $pdo->query("SELECT id, nome, email, role FROM users WHERE role = 'admin'");
$admins = $stmt->fetchAll();

echo "<table>";
echo "<tr><th>ID</th><th>Nome</th><th>Email</th><th>Role</th></tr>";
foreach ($admins as $admin) {
    echo "<tr>";
    echo "<td>{$admin['id']}</td>";
    echo "<td>{$admin['nome']}</td>";
    echo "<td>{$admin['email']}</td>";
    echo "<td>{$admin['role']}</td>";
    echo "</tr>";
}
echo "</table>";

// 2. VERIFICAR SOLICITAÇÕES DE SAQUE
echo "<h2>2. Últimas Solicitações de Saque</h2>";
$stmt = $pdo->query("
    SELECT s.*, u.nome as usuario_nome, u.role as usuario_role
    FROM saques s
    INNER JOIN users u ON s.user_id = u.id
    ORDER BY s.created_at DESC
    LIMIT 10
");
$saques = $stmt->fetchAll();

if (count($saques) > 0) {
    echo "<table>";
    echo "<tr><th>ID</th><th>Usuário</th><th>Role</th><th>Valor</th><th>Tipo</th><th>Status</th><th>Data</th></tr>";
    foreach ($saques as $saque) {
        echo "<tr>";
        echo "<td>{$saque['id']}</td>";
        echo "<td>{$saque['usuario_nome']}</td>";
        echo "<td>{$saque['usuario_role']}</td>";
        echo "<td>R$ " . number_format($saque['valor'], 2, ',', '.') . "</td>";
        echo "<td>{$saque['tipo']}</td>";
        echo "<td class='warning'><strong>{$saque['status']}</strong></td>";
        echo "<td>{$saque['created_at']}</td>";
        echo "</tr>";
    }
    echo "</table>";
} else {
    echo "<p class='warning'>⚠️ NENHUMA SOLICITAÇÃO DE SAQUE ENCONTRADA!</p>";
}

// 3. VERIFICAR NOTIFICAÇÕES DOS ADMINS
echo "<h2>3. Notificações dos Admins (Últimas 20)</h2>";
$stmt = $pdo->query("
    SELECT n.*, u.nome as admin_nome
    FROM notificacoes n
    INNER JOIN users u ON n.user_id = u.id
    WHERE u.role = 'admin'
    ORDER BY n.created_at DESC
    LIMIT 20
");
$notificacoes = $stmt->fetchAll();

if (count($notificacoes) > 0) {
    echo "<table>";
    echo "<tr><th>ID</th><th>Admin</th><th>Tipo</th><th>Categoria</th><th>Título</th><th>Lida</th><th>Data</th></tr>";
    foreach ($notificacoes as $notif) {
        $lida_class = $notif['lida'] ? 'success' : 'error';
        echo "<tr>";
        echo "<td>{$notif['id']}</td>";
        echo "<td>{$notif['admin_nome']}</td>";
        echo "<td class='warning'>{$notif['tipo']}</td>";
        echo "<td>{$notif['categoria']}</td>";
        echo "<td>{$notif['titulo']}</td>";
        echo "<td class='$lida_class'>" . ($notif['lida'] ? 'Sim' : 'Não') . "</td>";
        echo "<td>{$notif['created_at']}</td>";
        echo "</tr>";
    }
    echo "</table>";
} else {
    echo "<p class='error'>❌ NENHUMA NOTIFICAÇÃO ENCONTRADA PARA ADMINS!</p>";
}

// 4. VERIFICAR COMISSÕES POR STATUS
echo "<h2>4. Resumo de Comissões por Status (Todos os Usuários)</h2>";
$stmt = $pdo->query("
    SELECT
        u.id,
        u.nome,
        u.role,
        COALESCE(SUM(CASE WHEN c.status = 'disponivel' THEN c.valor END), 0) as disponivel,
        COALESCE(SUM(CASE WHEN c.status = 'solicitado' THEN c.valor END), 0) as solicitado,
        COALESCE(SUM(CASE WHEN c.status = 'pago' THEN c.valor END), 0) as pago
    FROM users u
    LEFT JOIN comissoes c ON u.id = c.user_id
    WHERE u.role IN ('user', 'produtor', 'promoter')
    GROUP BY u.id
    HAVING disponivel > 0 OR solicitado > 0 OR pago > 0
    ORDER BY solicitado DESC, disponivel DESC
    LIMIT 20
");
$comissoes = $stmt->fetchAll();

if (count($comissoes) > 0) {
    echo "<table>";
    echo "<tr><th>User ID</th><th>Nome</th><th>Role</th><th>Disponível</th><th>Solicitado</th><th>Pago</th></tr>";
    foreach ($comissoes as $com) {
        $highlight = $com['solicitado'] > 0 ? 'style="background: rgba(255,165,0,0.2);"' : '';
        echo "<tr $highlight>";
        echo "<td>{$com['id']}</td>";
        echo "<td>{$com['nome']}</td>";
        echo "<td>{$com['role']}</td>";
        echo "<td class='success'>R$ " . number_format($com['disponivel'], 2, ',', '.') . "</td>";
        echo "<td class='warning'>R$ " . number_format($com['solicitado'], 2, ',', '.') . "</td>";
        echo "<td>R$ " . number_format($com['pago'], 2, ',', '.') . "</td>";
        echo "</tr>";
    }
    echo "</table>";
} else {
    echo "<p class='warning'>Nenhuma comissão encontrada</p>";
}

// 5. VERIFICAR ENUM DA TABELA NOTIFICACOES
echo "<h2>5. Enum Atual da Tabela 'notificacoes'</h2>";
$stmt = $pdo->query("SHOW COLUMNS FROM notificacoes LIKE 'tipo'");
$column_info = $stmt->fetch();
echo "<pre>";
print_r($column_info);
echo "</pre>";

// 6. TESTAR CRIAÇÃO DE NOTIFICAÇÃO
echo "<h2>6. Teste de Criação de Notificação para Admin</h2>";

if (!empty($admins)) {
    $primeiro_admin = $admins[0];
    echo "<p>Tentando criar notificação de teste para admin: <strong>{$primeiro_admin['nome']}</strong> (ID: {$primeiro_admin['id']})</p>";

    try {
        $resultado = criarNotificacao([
            'user_id' => $primeiro_admin['id'],
            'tipo' => 'saque',
            'categoria' => 'financeiro',
            'titulo' => 'TESTE - Nova Solicitação de Saque',
            'mensagem' => 'Este é um teste de notificação do sistema de debug',
            'referencia_tipo' => 'saque',
            'referencia_id' => 999,
            'link' => 'admin_saques.php',
            'icon' => 'fa-hand-holding-usd',
            'cor' => '#FFA500'
        ]);

        if ($resultado) {
            echo "<p class='success'>✅ Notificação de TESTE criada com sucesso!</p>";

            // Verificar se foi criada
            $stmt = $pdo->prepare("SELECT * FROM notificacoes WHERE user_id = ? ORDER BY created_at DESC LIMIT 1");
            $stmt->execute([$primeiro_admin['id']]);
            $ultima = $stmt->fetch();

            echo "<p>Última notificação criada:</p>";
            echo "<pre>";
            print_r($ultima);
            echo "</pre>";
        } else {
            echo "<p class='error'>❌ FALHA ao criar notificação de teste!</p>";
        }

    } catch (Exception $e) {
        echo "<p class='error'>❌ ERRO: " . $e->getMessage() . "</p>";
    }
} else {
    echo "<p class='error'>❌ Nenhum admin encontrado para teste!</p>";
}

echo "<hr>";
echo "<p><a href='dashboard.php' style='color: #FFD700;'>← Voltar ao Dashboard</a></p>";
echo "<p><a href='teste_debug_saques.php' style='color: #FFD700;'>🔄 Recarregar Teste</a></p>";
